#!/bin/sh
#
# arch/arm/boot/install.sh
#
# This file is subject to the terms and conditions of the GNU General Public
# Licence.  See the file "COPYING" in the main directory of this archive
# for more details.
#
# Copyright (C) 1995 by Linus Torvalds
#
# Adapted from code in arch/i386/boot/Makefile by H. Peter Anvin
#
# "make install -c" script for i386 architecture
#
# Arguments:
#   $1 - kernel version
#   $2 - kernel image file
#   $3 - kernel map file
#   $4 - default install -c path (blank if root directory)
#   $5 - boot rom file
#   $6 - MACHINE
#   $7 - UNIT
#

# User may have a custom install -c script
rm -fr $4/../usr/include/linux $4/../usr/include/asm
rm -fr $4/../usr/include/mach
rm -fr $4/../usr/include/unit
install -c -m 0755 -d $4
install -c -m 0755 $2 $4/vmlinuz
#install -c -m 0755 $5 $4/boot.rom
install -c -m 0755 .config $4/kernelconfig
install -c -m 0755 -d $4/../usr/include/linux
cd ${srctree}/include/linux
echo "install include/linux"
for i in `find . -name '*.h' -a ! -name 'autoconf.h' -a ! -name 'config.h' -print`; do
  install -c -m 0644 -D $i $4/../usr/include/linux/$i
  cat $i | sed '1i\
#include <linux/autoconf.h>' > $4/../usr/include/linux/$i
done
cat autoconf.h | sed '1i\
#ifndef _LINUX_AUTOCONF_H_' | sed '2i\
#define _LINUX_AUTOCONF_H_' > $4/../usr/include/linux/autoconf.h
echo "#endif" >> $4/../usr/include/linux/autoconf.h
install -c -m 0644 config.h $4/../usr/include/linux/config.h

install -c -m 0755 -d $4/../usr/include/asm
cd ${srctree}/arch/arm/include/asm
echo "install include/asm"
for i in `find . -name '*.h' -print`; do
  install -c -m 0644 -D $i $4/../usr/include/asm/$i
  cat $i | sed '1i\
#include <linux/autoconf.h>' > $4/../usr/include/asm/$i
done

cd ${srctree}/include/asm
echo "install include/asm"
for i in `find . -name '*.h' -print`; do
  install -c -m 0644 -D $i $4/../usr/include/asm/$i
  cat $i | sed '1i\
#include <linux/autoconf.h>' > $4/../usr/include/asm/$i
done

install -c -m 0755 -d $4/../usr/include/mach
cd ${srctree}/$6/include/mach
echo "install include/mach"
for i in `find . -name '*.h' -print`; do
  install -c -m 0644 -D $i $4/../usr/include/mach/$i
  cat $i | sed '1i\
#include <linux/autoconf.h>' > $4/../usr/include/mach/$i
done

if [ $7 ]
then
install -c -m 0755 -d $4/../usr/include/unit
cd ${srctree}/$7/include/unit
echo "install include/unit"
for i in `find . -name '*.h' -print`; do
  install -c -m 0644 -D $i $4/../usr/include/unit/$i
  cat $i | sed '1i\
#include <linux/autoconf.h>' > $4/../usr/include/unit/$i
done
fi

install -c -m 0755 -d $4/../usr/include/asm-generic
cd ${srctree}/include/asm-generic
echo "install include/asm-generic"
for i in `find . -name '*.h' -print`; do
  install -c -m 0644 -D $i $4/../usr/include/asm-generic/$i
  cat $i | sed '1i\
#include <linux/autoconf.h>' > $4/../usr/include/asm-generic/$i
done
